<?php
/**
 * The Template for displaying all single posts.
 *
 * @package Spotlight
 */

get_header(); ?>

<?php global $get_layout_option; ?>

	<div id="primary" class="content-area <?php echo get_theme_mod( 'body_container' ); ?> text-center">
		<main id="main" class="site-main" role="main">

		<?php while ( have_posts() ) : the_post(); ?>

			<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
				<div class="post-divider"></div>
				<header class="entry-header">
					<?php spotlight_post_nav(); ?>
					<h1 class="entry-title text-center"><?php the_title(); ?></h1>

					<div class="entry-meta">
						<p><span>Date: </span><time class="entry-date published" datetime="<?php echo esc_html(the_time('F j, Y')); ?>"><?php echo esc_html(the_time('F j, Y')); ?></time>
						<?php if(get_field('client_name')) { 
							echo '<strong>&nbsp; &middot; &nbsp;</strong><span>Client: </span>' . get_field('client_name') . ''; } 
						?>
						<?php if(get_field('client_url')) { 
							echo '<strong>&nbsp; &middot; &nbsp;</strong><span>URL: </span><a href="' . get_field('client_url') . '" target="_blank">' . get_field('client_url') . '</a>'; } 
						?>
						<?php if(get_spotlight_tags()) { 
							echo '<strong>&nbsp; &middot; &nbsp;</strong><span>Tags: </span>'; the_spotlight_tags(); } 
						?>
					</div><!-- .entry-meta -->
				</header><!-- .entry-header -->

				<div class="entry-content">
					<?php the_content(); ?>
					<?php
						wp_link_pages( array(
							'before' => '<div class="page-links">' . __( 'Pages:', 'spotlight' ),
							'after'  => '</div>',
						) );
					?>
				</div><!-- .entry-content -->

				<footer class="entry-meta">
					<?php edit_post_link( __( 'Edit', 'spotlight' ), '<span class="edit-link">', '</span>' ); ?>
				</footer><!-- .entry-meta -->
			</article><!-- #post-## -->

		<?php endwhile; // end of the loop. ?>

		</main><!-- #main -->
	</div><!-- #primary -->

<?php get_footer(); ?>