<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package Spotlight
 */

get_header(); 

$get_layout_option = default_homepage_layout( get_theme_mod( 'default_homepage_layouts' ), get_theme_mod( 'default_homepage_meta' ) );

?>

	<div id="primary" class="content-area <?php echo $get_layout_option['container']; ?>" data-margin-bottom="<?php echo $get_layout_option['container-margin-bottom']; ?>">
		<main id="main" class="site-main" role="main">

      <div id="freewall" class="works" data-fixsize="true" data-animate="true" data-cell-width="<?php echo $get_layout_option['cell-width']; ?>" data-cell-height="20" data-gutter-x="<?php echo get_theme_mod( 'default_homepage_gutter_x' ); ?>" data-gutter-y="<?php	if ( $get_layout_option['gutter-y'] == 0 ) { echo get_theme_mod( 'default_homepage_gutter_x' ); }	else { echo $get_layout_option['gutter-y']; } ?>">           

  			<?php if ( have_posts() ) : ?>
          <?php while ( have_posts() ) : the_post(); ?> 

            <div class="item">
              <a href="<?php the_permalink(); ?>" rel="bookmark">
                <?php if ( has_post_thumbnail() ) { the_post_thumbnail($get_layout_option['thumbnail-size']); } ?>
              </a>
              <div class="item-meta">
              	<?php if ( get_theme_mod( 'default_homepage_meta' ) == 'both' ) { ?> 
              		<h2><?php the_title(); ?></h2> 
              		<p><?php the_spotlight_tags(); ?></p>
              	<?php } elseif ( get_theme_mod( 'default_homepage_meta' ) == 'title' ) { ?>
              		<h2><?php the_title(); ?></h2>
              	<?php } elseif ( get_theme_mod( 'default_homepage_meta' ) == 'tags' ) { ?>
              		<p><?php the_spotlight_tags(); ?></p>
              	<?php } ?>
              </div>
            </div> <!-- /item -->

          <?php endwhile; ?>

          <?php else : ?>
            <p><?php _e( 'No posts has been published or refresh your browser.' ) ?>.</p>
        <?php endif; ?>

      </div> <!-- /works --> 

      <!-- show pagination here -->
      <?php spotlight_paging_nav(); ?>
      
		</main><!-- #main -->
	</div><!-- #primary -->

<?php get_footer(); ?>
