<?php
/**
 * spotlight Theme Customizer
 *
 * @package spotlight
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function spotlight_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';


  // Add header section -----------------------------------------------------
  // ------------------------------------------------------------------------
  $wp_customize->add_section( 'logo_section', array(
    'title'       => __( 'Upload Logo', 'spotlight' ),
    'description' => __( 'Upload normal and retina logo', 'spotlight' ),
    'priority'    => '10'      
  ) );

  // Require my-customize-image-reloaded-control
  require_once( 'my-customize-image-reloaded-control.php' );

  // Header logo setting & control
  $wp_customize->add_setting( 'header_logo' );

  $wp_customize->add_control( new My_Customize_Image_Reloaded_Control ( $wp_customize, 'header_logo', array (
    'label'   => 'Logo',
    'section' => 'logo_section',
    'context'   => 'my-custom-logo'

   ) ) );  

  // Header logo @2x setting & control
  $wp_customize->add_setting( 'header_logo_2x' );

    $wp_customize->add_control( new My_Customize_Image_Reloaded_Control ( $wp_customize, 'header_logo_2x', array (
    'label'   => 'Retina Logo',
    'section' => 'logo_section',
    'context'   => 'my-custom-logo'

   ) ) ); 


  // Add default homepage section -----------------------------------------------------
  // ------------------------------------------------------------------------
  $wp_customize->add_section( 'default_homepage_section', array(
    'title'       => __( 'Default Homepage Layouts', 'spotlight' ),
    'description'       => __( 'Choose one of the default layouts.', 'spotlight' ),
    'priority'    => '25'      
  ) );

  // Homepage Layout setting & control
  $wp_customize->add_setting( 'default_homepage_layouts', array(
    'default'     => 'container_normal_unequal_grid'
  ) );

  $wp_customize->add_control( 'default_homepage_layouts', array(
    'label'       => __( 'Which homepage layout do you prefer?', 'spotlight' ),
    'section'     => 'default_homepage_section',
    'type'        => 'radio',
    'choices'     => array( 
      'full_width_normal_unequal_grid'                => __('Full-width Normal Unequal Grid', 'spotlight'), 
      'full_width_small_unequal_grid'                 => __('Full-width Small Unequal Grid', 'spotlight'),
      'full_width_mini_unequal_grid'                  => __('Full-width Mini Unequal Grid', 'spotlight'),  
      'full_width_small_equal_grid'                   => __('Full-width Small Equal Grid', 'spotlight'),
      'full_width_mini_equal_grid'                    => __('Full-width Mini Equal Grid', 'spotlight'),

      'container_normal_unequal_grid'                 => __('1170px Normal Unequal Grid', 'spotlight'), 
      'container_small_unequal_grid'                  => __('1170px Small Unequal Grid', 'spotlight'), 
      'container_mini_unequal_grid'                   => __('1170px Mini Unequal Grid', 'spotlight'),
      'container_normal_equal_grid'                   => __('1170px Normal Equal Grid', 'spotlight'), 
      'container_small_equal_grid'                    => __('1170px Small Equal Grid', 'spotlight'),
      'container_mini_equal_grid'                     => __('1170px Mini Equal Grid', 'spotlight'),
      
      'narrow_normal_unequal_grid'                    => __('970px Normal Unequal Grid', 'spotlight'),
      'narrow_small_unequal_grid'                     => __('970px Small Unequal Grid', 'spotlight'), 
      'narrow_mini_unequal_grid'                      => __('970px Mini Unequal Grid', 'spotlight'),
      'narrow_normal_equal_grid'                      => __('970px Normal Equal Grid', 'spotlight'), 
      'narrow_small_equal_grid'                       => __('970px Small Equal Grid', 'spotlight'),
      'narrow_mini_equal_grid'                        => __('970px Mini Equal Grid', 'spotlight'),
    ),

    ) );

  // Homepage Thumbnail Title and Tags setting & control
  $wp_customize->add_setting( 'default_homepage_meta', array(
    'default'     => 'none'
  ) );

  $wp_customize->add_control( 'default_homepage_meta', array(
    'label'       => __( 'Do you prefer to show item title and tags?', 'spotlight' ),
    'section'     => 'default_homepage_section',
    'type'        => 'radio',
      'choices'     => array( 
        'both'                  => __('Both Title and Tags', 'spotlight'), 
        'title'                 => __('Only Title', 'spotlight'),
        'tags'                  => __('Only Tags', 'spotlight'), 
        'none'                  => __('None', 'spotlight'), 
      ),
  ) );

  // Homepage Gutter X setting & control
  $wp_customize->add_setting( 'default_homepage_gutter_x', array(
    'default'     => 10
  ) );

  $wp_customize->add_control( 'default_homepage_gutter_x', array(
    'label'       => __( 'Do you prefer to show gutter between items?', 'spotlight' ),
    'section'     => 'default_homepage_section',
    'type'        => 'text',

  ) );

  // Add Body Container section -----------------------------------------------------
  // ------------------------------------------------------------------------
  $wp_customize->add_section( 'body_container_section', array(
    'title'       => __( 'Body Container', 'spotlight' ),
    'description'       => __( 'Choose body container, it does not affect on homepage but the rest of pages are affected.', 'spotlight' ),
    'priority'    => '22'      
  ) );

  // Body Container setting & control
  $wp_customize->add_setting( 'body_container', array(
    'default'     => 'container'
  ) );

  $wp_customize->add_control( 'body_container', array(
    'label'       => __( 'Which body container do you prefer?', 'spotlight' ),
    'section'     => 'body_container_section',
    'type'        => 'radio',
    'choices'     => array( 
      'full_width_container'              => __('Full-width Container', 'spotlight'), 
      'container'                         => __('1170px Container', 'spotlight'),
      'narrow container'                  => __('970px Container', 'spotlight'), 
    ),

    ) );


  // Add footer section -----------------------------------------------------
  // ------------------------------------------------------------------------
  $wp_customize->add_section( 'footer_section', array(
    'title'       => __( 'Footer', 'spotlight' ),
    'description' => __( 'Change footer text and link', 'spotlight' ),
    'priority'    => '900'      
  ) );

  // Footer copyright setting and control
  $wp_customize->add_setting( 'footer_copyright', array(
    'default'     => __( '&copy; 2013 All rights reserved | Theme by <a href="http://bootstrapee.com" target="_blank">Bootstrapee</a>', 'spotlight' )
  ) );

  $wp_customize->add_control( 'footer_copyright', array (
    'label'       => __( 'Enter copyright text', 'spotlight' ),
    'type'        => 'text',
    'section'     => 'footer_section',
  ) );


}
add_action( 'customize_register', 'spotlight_customize_register' );

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function spotlight_customize_preview_js() {
	wp_enqueue_script( 'spotlight_customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), '20130508', true );
}
add_action( 'customize_preview_init', 'spotlight_customize_preview_js' );
