<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="content">
 *
 * @package Spotlight
 */
?>

<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<link rel="shortcut icon" href="/favicon.ico" type="image/x-icon">
<link rel="icon" href="/favicon.ico" type="image/x-icon">
<link href='http://fonts.googleapis.com/css?family=IM+Fell+French+Canon:400italic' rel='stylesheet' type='text/css'>

<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title><?php wp_title( '|', true, 'right' ); ?></title>
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">

<!-- Favicons -->
<link rel="apple-touch-icon-precomposed" sizes="144x144" href="<?php echo get_template_directory_uri(); ?>/img/ico/apple-touch-icon-144-precomposed.png">
<link rel="shortcut icon" href="<?php echo get_template_directory_uri(); ?>/img/ico/favicon.png">

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<div id="page" class="hfeed site">
		<?php do_action( 'before' ); ?>
		<header id="masthead" class="site-header" role="banner">
			<div class="<?php echo get_theme_mod( 'body_container' ); ?> text-center">
				<div class="site-branding">
					<?php if( get_theme_mod('header_logo') ): ?>
						<a href="<?php echo home_url(); ?>"><img src="<?php echo get_theme_mod('header_logo'); ?>" data-at2x="<?php echo get_theme_mod('header_logo_2x'); ?>" alt="<?php bloginfo('name'); ?>"></a>
					<?php else: ?>
						<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
					<?php endif; ?>
					<h2 class="site-description"><?php bloginfo( 'description' ); ?></h2>
				</div>
				<nav class="main-navigation" role="navigation">
					<?php wp_nav_menu( array( 
						'theme_location' => 'primary', 
						'container' => 'ul', 
						'items_wrap' => '<ul class="list-inline">%3$s</ul>'
					) ); ?>
				</nav><!-- #site-navigation -->
			</div> <!-- /container -->

		</header><!-- #masthead -->

		<div id="content" class="site-content">
