<?php
/**
 * Spotlight functions and definitions
 *
 * @package Spotlight
 */

/**
 * Set the content width based on the theme's design and stylesheet.
 */
if ( ! isset( $content_width ) ) {
	$content_width = 640; /* pixels */
}

if ( ! function_exists( 'spotlight_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function spotlight_setup() {

	/*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 * If you're building a theme based on Spotlight, use a find and replace
	 * to change 'spotlight' to the name of your theme in all the template files
	 */
	load_theme_textdomain( 'spotlight', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link http://codex.wordpress.org/Function_Reference/add_theme_support#Post_Thumbnails
	 */
	add_theme_support( 'post-thumbnails' );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary' => __( 'Primary Menu', 'spotlight' ),
		'footer' => __( 'Footer Menu', 'spotlight' ),
	) );

	// Setup the WordPress core custom background feature.
	add_theme_support( 'custom-background', apply_filters( 'spotlight_custom_background_args', array(
		'default-color' => 'ffffff',
		'default-image' => '',
	) ) );

	// Add custom image size
	if ( function_exists( 'add_image_size' ) ) { 
		add_image_size( 'full-width-normal-unequal-grid', 420, 9999, true ); //(cropped)
		add_image_size( 'full-width-small-unequal-grid', 250, 999, true ); //(cropped)
		add_image_size( 'full-width-mini-unequal-grid', 210, 999, true ); //(cropped)
		add_image_size( 'full-width-normal-equal-grid', 420, 420, true ); //(cropped)
		add_image_size( 'full-width-small-equal-grid', 250, 250, true ); //(cropped)
		add_image_size( 'full-width-mini-equal-grid', 230, 230, true ); //(cropped)

		add_image_size( 'container-normal-unequal-grid', 380, 9999, true ); //(cropped)
		add_image_size( 'container-small-unequal-grid', 280, 9999, true ); //(cropped)
		add_image_size( 'container-mini-unequal-grid', 230, 9999, true ); //(cropped)
		add_image_size( 'container-normal-equal-grid', 450, 450, true ); //(cropped)
		add_image_size( 'container-small-equal-grid', 280, 280, true ); //(cropped)
		add_image_size( 'container-mini-equal-grid', 230, 230, true ); //(cropped)

		add_image_size( 'narrow-normal-unequal-grid', 470, 9999, true ); //(cropped)
		add_image_size( 'narrow-small-unequal-grid', 310, 9999, true ); //(cropped)
		add_image_size( 'narrow-mini-unequal-grid', 230, 9999, true ); //(cropped)
		add_image_size( 'narrow-normal-equal-grid', 400, 400, true ); //(cropped)
		add_image_size( 'narrow-small-equal-grid', 310, 310, true ); //(cropped)
		add_image_size( 'narrow-mini-equal-grid', 230, 230, true ); //(cropped)
	}

}
endif; // spotlight_setup
add_action( 'after_setup_theme', 'spotlight_setup' );


/**
 * Enqueue scripts and styles.
 */
function spotlight_scripts() {
	wp_enqueue_style( 'spotlight-bootstrap-style', get_template_directory_uri() . '/css/bootstrap.min.css' );

	wp_enqueue_style( 'spotlight-fontawesome', get_template_directory_uri() . '/css/fontawesome.min.css' );

	wp_enqueue_style( 'spotlight-style', get_stylesheet_uri() );

	wp_enqueue_script( 'spotlight-bootstrap-script', get_template_directory_uri() . '/js/bootstrap.min.js', array('jquery'), '20130115', true );
	
	wp_enqueue_script( 'spotlight-freewall-script', get_template_directory_uri() . '/js/freewall.min.js', array('jquery'), '20130115', true );
	
	wp_enqueue_script( 'spotlight-freewall-script', get_template_directory_uri() . '/js/retina.min.js', array(), '20130115', true );

	wp_enqueue_script( 'spotlight-script', get_template_directory_uri() . '/js/script.js', array('jquery'), '20130115', true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'spotlight_scripts' );

/**
 * Enqueue scripts and styles for IE.
 */
function spotlight_ie_scripts() {
	echo '<!--[if lt IE 9]> <script src="<?php echo get_template_directory_uri(); ?>/js/html5.js" type="text/javascript"></script> <![endif]-->';
	echo '<!--[if lt IE 8]> <script src="<?php echo get_template_directory_uri(); ?>/js/respond.min.js" type="text/javascript"></script> <![endif]-->';
}
add_action( 'wp_head', 'spotlight_ie_scripts' );

/**
 * Implement the Custom Header feature.
 */
//require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Include Advanced custom field plugin
 */
define( 'ACF_LITE' , true );
include_once(get_template_directory() . '/inc/advanced-custom-fields/acf.php' );
include_once(get_template_directory() . '/inc/custom-field.php' );